/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.enums;

import com.alexander.mutantmore.init.EntityTypeInit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public enum MobMutations {
    NONE(0, "none", (EntityType)null, (EntityType)null, null),
    MUTANT_WITHER_SKELETON(1, "mutant_wither_skeleton", EntityType.f_20497_, (EntityType)EntityTypeInit.MUTANT_WITHER_SKELETON.get(), null),
    MUTANT_BLAZE(2, "mutant_blaze", EntityType.f_20551_, (EntityType)EntityTypeInit.MUTANT_BLAZE.get(), null),
    MUTANT_SHULKER(3, "mutant_shulker", EntityType.f_20521_, (EntityType)EntityTypeInit.MUTANT_SHULKER.get(), null);

    @Nullable
    public final Lazy<? extends EntityType<?>> baseLazyEntityType;
    @Nullable
    public final EntityType<?> baseEntityType;
    @Nullable
    public final Lazy<? extends EntityType<?>> createdLazyEntityType;
    @Nullable
    public final EntityType<?> createdEntityType;
    @Nullable
    public Predicate<Entity> mutationPredicate;
    public int id;
    public String name;

    private MobMutations(@Nullable int id, @Nullable String name, RegistryObject<? extends EntityType<?>> baseLazyEntityType, RegistryObject<? extends EntityType<?>> createdLazyEntityType, Predicate<Entity> mutationPredicate) {
        this.id = id;
        this.name = name;
        this.baseEntityType = null;
        this.createdEntityType = null;
        this.mutationPredicate = mutationPredicate;
        this.baseLazyEntityType = baseLazyEntityType != null ? Lazy.of(() -> baseLazyEntityType.get()) : null;
        this.createdLazyEntityType = createdLazyEntityType != null ? Lazy.of(() -> createdLazyEntityType.get()) : null;
    }

    private MobMutations(@Nullable int id, @Nullable String name, EntityType<?> baseEntityType, RegistryObject<? extends EntityType<?>> createdLazyEntityType, Predicate<Entity> mutationPredicate) {
        this.id = id;
        this.name = name;
        this.baseLazyEntityType = null;
        this.createdEntityType = null;
        this.mutationPredicate = mutationPredicate;
        this.baseEntityType = baseEntityType;
        this.createdLazyEntityType = createdLazyEntityType != null ? Lazy.of(() -> createdLazyEntityType.get()) : null;
    }

    private MobMutations(@Nullable int id, @Nullable String name, EntityType<?> baseEntityType, EntityType<?> createdEntityType, Predicate<Entity> mutationPredicate) {
        this.id = id;
        this.name = name;
        this.baseLazyEntityType = null;
        this.createdLazyEntityType = null;
        this.mutationPredicate = mutationPredicate;
        this.baseEntityType = baseEntityType;
        this.createdEntityType = createdEntityType;
    }

    private MobMutations(@Nullable int id, @Nullable String name, RegistryObject<? extends EntityType<?>> baseLazyEntityType, EntityType<?> createdEntityType, Predicate<Entity> mutationPredicate) {
        this.id = id;
        this.name = name;
        this.baseEntityType = null;
        this.createdLazyEntityType = null;
        this.mutationPredicate = mutationPredicate;
        this.baseLazyEntityType = baseLazyEntityType != null ? Lazy.of(() -> baseLazyEntityType.get()) : null;
        this.createdEntityType = createdEntityType;
    }

    public static MobMutations byBaseMob(Mob mob) {
        for (MobMutations mobMutationEnum : MobMutations.values()) {
            if (mob.m_6095_() != mobMutationEnum.baseEntityType || (mobMutationEnum.mutationPredicate == null || !mobMutationEnum.mutationPredicate.test((Entity)mob)) && mobMutationEnum.mutationPredicate != null) continue;
            return mobMutationEnum;
        }
        return NONE;
    }

    public static MobMutations byCreatedMob(EntityType<?> type) {
        for (MobMutations mobMutationEnum : MobMutations.values()) {
            if (type != mobMutationEnum.createdEntityType) continue;
            return mobMutationEnum;
        }
        return NONE;
    }
}

